
// SampleASWSDlg.cpp :  
//

#include "stdafx.h"
#include "SampleASWS.h"
#include "SampleASWSDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//  α׷  Ǵ CAboutDlg ȭ Դϴ.

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ȭ  Դϴ.
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV Դϴ.

// Դϴ.
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSampleASWSDlg ȭ 



CSampleASWSDlg::CSampleASWSDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_SAMPLEASWS_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleASWSDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_BT_ASWS_ONOFF, m_btASWS_OnOff);
	DDX_Control(pDX, IDC_ST_ASWS_STATUS, m_stASWS_Status);
	DDX_Control(pDX, IDC_ST_ASWS_TORQUE, m_stASWS_Torque);
	DDX_Control(pDX, IDC_ST_ASWS_ANGLE, m_stASWS_Angle);
	DDX_Control(pDX, IDC_ST_ASWS_VELOCITY, m_stASWS_Velocity);
	DDX_Control(pDX, IDC_RAD_INNO_TORQUE, m_rdInnoTorque);
	DDX_Control(pDX, IDC_RAD_DIRECT_TORQUE, m_rdDirectTorque);
	DDX_Control(pDX, IDC_RAD_DIRECT_POSITION, m_rdDirectPosition);
	DDX_Control(pDX, IDC_SLID_VEHSPEED, m_slidVehSpeed);
	DDX_Control(pDX, IDC_SLID_TORQUE, m_slidTorque);
	DDX_Control(pDX, IDC_SLID_ANGLE, m_slidAngle);
	DDX_Control(pDX, IDC_CHK_EFFECT, m_btEffect);
}

BEGIN_MESSAGE_MAP(CSampleASWSDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CH_ASWS_ACTIVE, &CSampleASWSDlg::OnBnClickedChAswsActive)
	ON_BN_CLICKED(IDC_BT_ASWS_ONOFF, &CSampleASWSDlg::OnBnClickedBtAswsOnoff)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLID_VEHSPEED, &CSampleASWSDlg::OnNMCustomdrawSlidVehspeed)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLID_TORQUE, &CSampleASWSDlg::OnNMCustomdrawSlidTorque)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLID_ANGLE, &CSampleASWSDlg::OnNMCustomdrawSlidAngle)
	ON_BN_CLICKED(IDC_RAD_INNO_TORQUE, &CSampleASWSDlg::OnBnClickedRadInnoTorque)
	ON_BN_CLICKED(IDC_RAD_DIRECT_TORQUE, &CSampleASWSDlg::OnBnClickedRadDirectTorque)
	ON_BN_CLICKED(IDC_RAD_DIRECT_POSITION, &CSampleASWSDlg::OnBnClickedRadDirectPosition)
	ON_BN_CLICKED(IDC_CHK_EFFECT, &CSampleASWSDlg::OnBnClickedChkEffect)
END_MESSAGE_MAP()


// CSampleASWSDlg ޽ ó

BOOL CSampleASWSDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// ý ޴ "..." ޴ ׸ ߰մϴ.

	// IDM_ABOUTBOX ý   ־ մϴ.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//  ȭ   մϴ.   α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// GUI Init
	m_slidVehSpeed.SetRange(0, 260);
	m_slidVehSpeed.SetTicFreq(1);
	m_slidVehSpeed.SetPos(0);

	m_slidTorque.SetRange(-86, 86);
	m_slidTorque.SetTicFreq(1);
	m_slidTorque.SetPos(0);

	m_slidAngle.SetRange(-540, 540);
	m_slidAngle.SetTicFreq(1);
	m_slidAngle.SetPos(0);

	// Timer Init
	SetTimer(0, 4, NULL);
		
	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void CSampleASWSDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ȭ ڿ ּȭ ߸ ߰   ׸
//  Ʒ ڵ尡 ʿմϴ.  /  ϴ MFC  α׷ 쿡
//  ӿũ  ۾ ڵ մϴ.

void CSampleASWSDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ.
HCURSOR CSampleASWSDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CSampleASWSDlg::OnBnClickedChAswsActive()
{
	BOOL bRes = ((CButton*)GetDlgItem(IDC_CH_ASWS_ACTIVE))->GetCheck();

	if (bRes == TRUE)
	{
		expASWS_SetActiveTorque(TRUE);
	}
	else
	{
		expASWS_SetActiveTorque(FALSE);
		expASWS_SetMode(-1);
	}
}

void CSampleASWSDlg::OnBnClickedBtAswsOnoff()
{
	BOOL bRes = ((CButton*)GetDlgItem(IDC_BT_ASWS_ONOFF))->GetCheck();

#ifdef Use_ASWS
	if (bRes == TRUE)
	{
		((CButton*)GetDlgItem(IDC_BT_ASWS_ONOFF))->SetWindowText("ASWS ON");
		((CButton*)GetDlgItem(IDC_CH_ASWS_ACTIVE))->SetCheck(1);
		expASWS_Thread_Start();
	}
	else
	{
		bTorqueFlag = FALSE;

		((CButton*)GetDlgItem(IDC_BT_ASWS_ONOFF))->SetWindowText("ASWS OFF");
		((CButton*)GetDlgItem(IDC_CH_ASWS_ACTIVE))->SetCheck(0);
		expASWS_Thread_Stop();
	}
#endif
}

void CSampleASWSDlg::InformationASWS()
{
#ifdef Use_ASWS
	CString str("");

	TRACE("1\n");

	m_nASWS_State = expASWS_GetStatus();

	switch (m_nASWS_State)
	{
	case STATUS_UNKNWON:
		str = "UnKnown";
		break;

	case STATUS_POWERDOWN:
		str = "PowerDown";
		break;

	case STATUS_INIT:
		str = "Kernel-Init";
		break;

	case STATUS_POWERON:
		str = "Servo On";
		break;

	case STATUS_NORMAL:
		str = "Normal";
		break;

	case STATUS_RUN:
		str = "Run";
		break;

	case STATUS_CALIBRATION:
		str = "Calibration";
		break;

	case STATUS_COMMUNICATION_ERROR:
		str = "Communication_error";
		break;

	case STATUS_OVERLOAD_ERROR:
		str = "Overload_error";
		break;
	}

	m_stASWS_Status.SetWindowText(str);

	// ASWS Active Check -  Used when ASWS is Normal
	if (m_nASWS_State == STATUS_NORMAL && bTorqueFlag == FALSE)
	{
		bTorqueFlag = TRUE;
		OnBnClickedChAswsActive();

		OnBnClickedRadInnoTorque();
	}
	
	// Get Monitoring - Steer Angle
	float fSteerAngle = expASWS_GetSteerAngle();
	str.Format("%.2f", fSteerAngle);
	m_stASWS_Angle.SetWindowText(str);

	// Get Monitoring - Steer Velocity
	float fVelocity = expASWS_GetSteerVelocity();
	str.Format("%.2f", fVelocity);
	m_stASWS_Velocity.SetWindowText(str);

	// Get Monitoring - Steer Torque
	float fTorque = expASWS_GetSteerInTorque();
	str.Format("%.2f", fTorque);
	m_stASWS_Torque.SetWindowText(str);

	if (m_nASWS_State == STATUS_RUN)
	{
		if (m_rdInnoTorque.GetCheck())
		{
			expASWS_SetMode(0);
			expASWS_SetVehSpeed(m_fVehSpeed);
		}
		else if (m_rdDirectTorque.GetCheck())
		{
			expASWS_SetMode(1);
			expASWS_SetTorqueValue(m_fTorque);
		}
		else if (m_rdDirectPosition.GetCheck())
		{
			expASWS_SetMode(2);
			expASWS_SetDirectAngleValue(m_fAngle);
		}
	}
#endif
}

void CSampleASWSDlg::OnNMCustomdrawSlidVehspeed(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	
	m_fVehSpeed = m_slidVehSpeed.GetPos();

	CString str("");

	str.Format("%d", (int)m_fVehSpeed);
	GetDlgItem(IDC_ED_VEHSPEED)->SetWindowText(str);

	*pResult = 0;
}

void CSampleASWSDlg::OnNMCustomdrawSlidTorque(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	
	m_fTorque = m_slidTorque.GetPos() / 10.0;

	CString str("");

	str.Format("%.1f", m_fTorque);
	GetDlgItem(IDC_ED_TORQUE)->SetWindowText(str);

	*pResult = 0;
}

void CSampleASWSDlg::OnNMCustomdrawSlidAngle(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	
	m_fAngle = m_slidAngle.GetPos();

	CString str("");

	str.Format("%d", (int)m_fAngle);
	GetDlgItem(IDC_ED_ANGLE)->SetWindowText(str);

	*pResult = 0;
}

void CSampleASWSDlg::OnBnClickedRadInnoTorque()
{
	m_rdInnoTorque.SetCheck(1);
	m_rdDirectTorque.SetCheck(0);
	m_rdDirectPosition.SetCheck(0);

	m_slidVehSpeed.SetPos(0);
	m_slidTorque.SetPos(0);
	m_slidAngle.SetPos(0);

	GetDlgItem(IDC_SLID_VEHSPEED)->EnableWindow(TRUE);
	GetDlgItem(IDC_ED_VEHSPEED)->EnableWindow(TRUE);
	GetDlgItem(IDC_SLID_TORQUE)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_TORQUE)->EnableWindow(FALSE);
	GetDlgItem(IDC_SLID_ANGLE)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_ANGLE)->EnableWindow(FALSE);
}

void CSampleASWSDlg::OnBnClickedRadDirectTorque()
{
	m_rdInnoTorque.SetCheck(0);
	m_rdDirectTorque.SetCheck(1);
	m_rdDirectPosition.SetCheck(0);

	m_slidVehSpeed.SetPos(0);
	m_slidTorque.SetPos(0);
	m_slidAngle.SetPos(0);

	GetDlgItem(IDC_SLID_VEHSPEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_VEHSPEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_SLID_TORQUE)->EnableWindow(TRUE);
	GetDlgItem(IDC_ED_TORQUE)->EnableWindow(TRUE);
	GetDlgItem(IDC_SLID_ANGLE)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_ANGLE)->EnableWindow(FALSE);
}

void CSampleASWSDlg::OnBnClickedRadDirectPosition()
{
	m_rdInnoTorque.SetCheck(0);
	m_rdDirectTorque.SetCheck(0);
	m_rdDirectPosition.SetCheck(1);

	m_slidVehSpeed.SetPos(0);
	m_slidTorque.SetPos(0);
	m_slidAngle.SetPos(0);

	GetDlgItem(IDC_SLID_VEHSPEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_VEHSPEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_SLID_TORQUE)->EnableWindow(FALSE);
	GetDlgItem(IDC_ED_TORQUE)->EnableWindow(FALSE);
	GetDlgItem(IDC_SLID_ANGLE)->EnableWindow(TRUE);
	GetDlgItem(IDC_ED_ANGLE)->EnableWindow(TRUE);
}

void CSampleASWSDlg::OnTimer(UINT_PTR nIDEvent)
{
	switch (nIDEvent)
	{
	case 0:
		InformationASWS();
		break;
	}

	CDialogEx::OnTimer(nIDEvent);
}

BOOL CSampleASWSDlg::PreTranslateMessage(MSG* pMsg)
{
	if ((pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN) || (pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_ESCAPE))
	{
		return TRUE;
	}

	return CDialogEx::PreTranslateMessage(pMsg);
}

void CSampleASWSDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	KillTimer(0);

	expASWS_Thread_Stop();
}

void CSampleASWSDlg::OnBnClickedChkEffect()
{
	if (m_btEffect.GetCheck())
	{
		expASWS_SetEffectOnOff(1.0, 5.0, true);
	}
	else
	{
		expASWS_SetEffectOnOff(0.0, 0.0, false);
	}
}
